/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.table;

import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.ui.bonsai.earth.TaskNode;
import com.ibm.hwmca.ui.bonsai.table.NameTableCellBean;
import com.ibm.psw.wcl.components.table.AbstractExtendedTableModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class TasksTableModel
extends AbstractExtendedTableModel {
    private List linkCells;
    private List captions;
    private Locale locale;

    public TasksTableModel(List tasks, Locale locale) {
        this.locale = locale;
        this.setData(tasks);
    }

    public void setData(List tasks) {
        this.linkCells = new ArrayList();
        this.captions = new ArrayList();
        TaskNode taskNode = null;
        Iterator i = tasks.iterator();
        while (i.hasNext()) {
            taskNode = (TaskNode)i.next();
            this.linkCells.add(new NameTableCellBean(taskNode.getName(this.locale), taskNode.getUrlString(), taskNode.getImageUrl(), taskNode.getImageName(), taskNode.getId()));
            this.captions.add(taskNode.getCaption(this.locale));
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", "colheader.taskname").toString(this.locale);
            }
            case 1: {
                return new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", "colheader.caption").toString(this.locale);
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.linkCells.size();
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.linkCells.get(row);
            }
            case 1: {
                return this.captions.get(row);
            }
        }
        return null;
    }
}

